function [ Lz ] = laplacianz_op( I )
%LAPLACIANZ_OP dimentional Laplacian
%   Usage:  [Lz] = laplacianz_op( I );
%
%   Input parameters:
%         I     : Input image 
%
%   Output parameters:
%         Lz    : Laplacian along z
%
%   Compute the sum of the laplacian along z. This operator is 
%   self-adjoint.
%
%   ..      Lz = I_zz
%
%   .. math::  \mathcal{L}_z = I_{zz}
%
%   See also: laplacian_op3 laplaciany_op div_op gradient_op
%

% Author: Nathnaael Perraudin
% Date  : 13 September 2013


dz = cat(3,I(:, :,2:end)-I(:, :,1:end-1) , zeros(size(I, 1),size(I, 2) ,1));


Lz = cat(3,dz(:, :,1) , dz(:, :,2:end-1)-dz(:, :,1:end-2) , -dz(:, :,end-1));


end
