function [ L ] = laplacian_op3( I )
%LAPLACIAN_OP3 3 dimentional Laplacian
%   Usage:  [I] = laplacian_op3( I );
%
%   Input parameters:
%         I     : Input image 
%
%   Output parameters:
%         I     : Laplacian
%
%   Compute the sum of the laplacian along x, y and z. This operator is
%   self-adjoint.
%
%   ..      L = I_xx + I_yy + I_zz
%
%   .. math::  \mathcal{L} = I_{xx} + I_{yy} + I_{zz}
%
%   See also: laplacianx_op laplaciany_op laplacianz_op div_op gradient_op
%

% Author: Nathnaael Perraudin
% Date  : 13 September 2013


L=laplacianx_op(I)+laplaciany_op(I)+laplacianz_op(I);

end

