
clear param_fid f1 f2 f3
tau1 = 0.02;
tau2 = 0.1;
verbose = 1;

% fig = figure(100);

param_fid.A         = @(x) M.*x;
param_fid.At        = @(x) M.*x;
param_fid.tight     = 1;


%time tikh
f2.prox = @(x,T) prox_l2grad(x',T*tau1)'; % X'*LT
f2.grad = @(x) tau1*2*x*G.jtv.LT';
f2.beta = 2*4*tau1; %G.jtv.lmax(LT)
f2.eval = @(x) tau1*norm(x*G.jtv.DiffT','fro').^2;


%graph tv
f3.prox = @(x,T) gsp_prox_tv(x,T*tau2,G,param_tv);
f3.eval = @(x) tau2*sum(gsp_norm_tv(G,x));

%RED
% param_solver.do_sol=@(x) plot_videoframe( x,[height width 1 T],[1 3 10 50],fig,xr );
param_fid.y = yr;
f1.grad = @(x) 2*M.*(x-param_fid.y);
f1.eval = @(x) norm(M.*(x-param_fid.y),'fro').^2;
f1.beta = 2;
zr = solvep(yr,{f1 f2 f3},param_solver);
compute_error(zr,xr)

%GREEN
% param_solver.do_sol=@(x) plot_videoframe( x,[height width 1 T],[1 3 10 50],fig,xg );
param_fid.y = yg;
f1.grad = @(x) 2*M.*(x-param_fid.y);
f1.eval = @(x) norm(M.*(x-param_fid.y),'fro').^2;
zg = solvep(yg,{f1 f2 f3},param_solver);
compute_error(zg,xg)

%BLUE
% param_solver.do_sol=@(x) plot_videoframe( x,[height width 1 T],[1 3 10 50],fig,xb );
param_fid.y = yb;
f1.grad = @(x) 2*M.*(x-param_fid.y);
f1.eval = @(x) norm(M.*(x-param_fid.y),'fro').^2;
zb = solvep(yb,{f1 f2 f3},param_solver);
compute_error(zb,xb)


z12(:,1,:) = zr;
z12(:,2,:) = zg;
z12(:,3,:) = zb;


Zr = reshape(zr,height,width,T);
Zg = reshape(zg,height,width,T);
Zb = reshape(zb,height,width,T);
Z12(:,:,1,:) = Zr;
Z12(:,:,2,:) = Zg;
Z12(:,:,3,:) = Zb;
