function [sol,X] = get_l1_dec(X,A,At,tau,nu)


if nargin<5
    nu = 1;
end

verbose = 2;
x0 = zeros(size(A(X)));
paramsolver.verbose = verbose;
paramsolver.tol = 1e-5;
paramsolver.maxit = 5;

ffid.grad = @(x) 2*A(At(x)-X);
ffid.eval = @(x) norm(At(x)-X).^2;
ffid.beta = 2*nu;

paraml1.verbose = verbose -1;
paraml1.tight = 0;
fl1.prox = @(x,T) prox_l1(x,T*tau,paraml1);
fl1.eval = @(x) tau*norm(vec(x),1);

sol = solvep(x0,{ffid,fl1},paramsolver);


%%

sol(abs(sol)<1e-3*max(abs(sol(:)))) = 0;

X = At(sol);

end