%% Joint filter of dynamic mesh
%
%   In this demo, we show the result of joint time-vertex filtering of
%   dynamyc mesh using a joint low-pass filter and a non-separable wave
%   filter.
%   Dataset can be found at http://research.microsoft.com/en-us/um/redmond/events/geometrycompression/data/default.html
%

% Author: Francesco Grassi
% Date: April 2017

gsp_start;

load dancer.mat

%% Signals
X1 = X(:,:,1) - repmat(mean(X(:,:,1),1),[N,1]);
X2 = X(:,:,2) - repmat(mean(X(:,:,2),1),[N,1]);
X3 = X(:,:,3) - repmat(mean(X(:,:,3),1),[N,1]);

X = cat(3,X1,X2,X3);

t0 = 20;
param.view = [0 90];
subplot(131)
scatter3(X(:,t0,1),X(:,t0,2),X(:,t0,3))
axis off
axis([min(vec(X(:,t0,1))) max(vec(X(:,t0,1))) min(vec(X(:,t0,2))) max(vec(X(:,t0,2))) min(vec(X(:,t0,3))) max(vec(X(:,t0,3))) ])
view(param.view)
title('Original')

%% Graph
x0 = squeeze(mean(X,2));
param.k = 20;
G = gsp_nn_graph(x0,param);
G = gsp_compute_fourier_basis(G);
G = gsp_jtv_graph(G,T);

%% Low-Pass Filtering
lcut = 0.1;
wcut = 0.1;

hlp = @( lambda,omega ) double(and(abs(lambda)<lcut,abs(omega)<wcut));
Ylp = squeeze(gsp_jtv_filter_analysis(G,hlp,'js',X));


subplot(132)
scatter3(Ylp(:,t0,1),Ylp(:,t0,2),Ylp(:,t0,3))
axis off
axis([min(vec(Ylp(:,t0,1))) max(vec(Ylp(:,t0,1))) min(vec(Ylp(:,t0,2))) max(vec(Ylp(:,t0,2))) min(vec(Ylp(:,t0,3))) max(vec(Ylp(:,t0,3))) ])
view(param.view)
title('Low-pass')

%% Wave Filtering

alpha = 1;
[g,ft] = gsp_jtv_design_wave(G,alpha);

Y1 = X1 + 0.3*gsp_jtv_filter_analysis(G,g,ft,X1);
Y2 = X2 + 0.3*gsp_jtv_filter_analysis(G,g,ft,X2);
Y3 = X3 + 0.3*gsp_jtv_filter_analysis(G,g,ft,X3);

Y = cat(3,Y1,Y2,Y3);


subplot(133)
scatter3(Y(:,t0,1),Y(:,t0,2),Y(:,t0,3))
axis off
axis([min(vec(Y(:,t0,1))) max(vec(Y(:,t0,1))) min(vec(Y(:,t0,2))) max(vec(Y(:,t0,2))) min(vec(Y(:,t0,3))) max(vec(Y(:,t0,3))) ])
view(param.view)
title('Wave')