%% Compactness of joint time-vertex harmonic representation of dynamic mesh

% Author: Francesco Grassi
% Date: April 2017

clear
close all
clc

gsp_start;

%%
%load dancer.mat
load dog.mat

p = 0:5:100;

x0 = squeeze(mean(X,2));
param.use_full = 0;
param.k = 5;
G = gsp_nn_graph(x0,param);
G = gsp_compute_fourier_basis(G);
G = gsp_jtv_graph(G,size(X,2),[],param);

Xhat = gsp_jft(G,X);
Xdot = gsp_tft(G,X);
Xtil = gsp_gft(G,X);


for ii=1:numel(p)
    fprintf('Percentile:%d \n',p(ii))
    Xhat2 = Xhat;
    Xdot2 = Xdot;
    Xtil2 = Xtil;
    
    Xhat2(abs(Xhat2)<prctile(abs(Xhat2(:)),p(ii))) = 0;
    Xdot2(abs(Xdot2)<prctile(abs(Xdot2(:)),p(ii))) = 0;
    Xtil2(abs(Xtil2)<prctile(abs(Xtil2(:)),p(ii))) = 0;
    
    err_jft(ii) = norm(vec(X - gsp_ijft(G,Xhat2)),'fro')/norm(vec(X),'fro');
    err_fft(ii) = norm(vec(X - gsp_itft(G,Xdot2)),'fro')/norm(vec(X),'fro');
    err_gft(ii) = norm(vec(X - gsp_igft(G,Xtil2)),'fro')/norm(vec(X),'fro');
    
end


%%
figure
semilogy(p,err_jft,'k.-',p,err_fft,'ko-',p,err_gft,'k--','linewidth',1)
ylim([1e-4 1])
legend('JFT','DFT','GFT')
xlabel('percentile of removed entries')
ylabel('normalized error')
grid on
