%% RKHS wavelet 1d


%% Initialisation

clear;
%close all;

% Loading toolbox
init_unlocbox();
 
verbose = 1; % verbosity level

gsp_reset_seed(0);

%% Creation of the problem

N = 500;  % Number of points
M = 50; % Number of labeled points
sigmaN = 0.02;
% b = 0.02;
% xi = [(1-b)*rand(1,N/2), 1+b+(1-b)*rand(1,N/2)]/2; 
% xi = xi(:,randperm(N));

xi = rand(1,N);

maxit = 500;
freal = @(x) double((x-0.5)>0)-0.5;
%freal = @(x) 1-floor(3*x);


yi = freal(xi(:,1:M))+sigmaN*randn(1,M); 

sigma = 3*max(abs(diff(sort(xi))))/2;
k = @(x,y) exp(-(x-y).^2/sigma^2);


tauRKHS = 0.02;
tauRKHS1 = 0.002;
tauGtik = 1;
tauGtv = 0.02;

%% 

% Evaluate the kernel on the data points
K = k(repmat(xi,N,1),repmat(xi',1,N));
Khalf = real(K^(1/2));
sigmaK = norm(K);

KL = k(repmat(xi,M,1),repmat(xi(:,1:M)',1,N));
sigmaKL = norm(KL);

% data fidelity
ffid.eval = @(x) norm(KL*x-yi','fro')^2;
ffid.grad = @(x) 2*KL'*(KL*x-yi');
ffid.beta = 2*sigmaKL^2;


% regularization RKHS
fp.eval = @(x) tauRKHS * sum(x'* K*x );
fp.grad = @(x) tauRKHS*2*K*x;
fp.beta = 2*tauRKHS*sigmaK;

% regularization RKHS TV
paraml1rkhs.A = @(x) Khalf*x;
paraml1rkhs.At = @(x) Khalf'*x;
paraml1rkhs.nu = sigmaK;
paraml1rkhs.tight = 0;
paraml1rkhs.verbose = verbose-1;
fp1.eval = @(x) tauRKHS1 * norm( Khalf*x,1 );
fp1.prox = @(x,T) prox_l1( x,tauRKHS1*T ,paraml1rkhs);


% Graph

G = gsp_nn_graph(xi');
G = gsp_adj2vec(G);
G = gsp_estimate_lmax(G);

paramtik.A = @(x) K*x;
paramtik.At = @(x) K'*x;
paramtik.nu = norm(K)^2;
paramtik.tight = 0;
paramtik.verbose = verbose-1;
paramtik.pcg = 1;

TMP = K*G.L*K;
ftik.prox = @(x,T) gsp_prox_tik(x,T*tauGtik,G,paramtik);
ftik.eval = @(x) tauGtik*gsp_norm_tik(G,K*x);
ftik.grad = @(x) tauGtik*2*TMP*x;
ftik.beta = 2*tauGtik*norm(TMP)^2;

% paramtv.A = @(x) K*x;
% paramtv.At = @(x) K'*x;
% paramtv.nu = norm(K)^2;
% paramtv.tight = 0;
% paramtv.verbose = verbose-1;
% paramtv.tol = 1e-8;
% 
% ftv.prox = @(x,T) gsp_prox_tv(x,T*tauGtv,G,paramtv);
% ftv.eval = @(x) tauGtv*gsp_norm_tv(G,K*x);


paraml1.tight = 1;
paraml1.verbose = verbose-1;

Op = G.Diff*K;
ftv.L = @(x) Op*x;
ftv.Lt = @(x) Op'*x;
ftv.norm_L = norm(Op)^2;
ftv.prox = @(x,T) prox_l1(x,T*tauGtv,paraml1);
ftv.eval = @(x) tauGtv*norm(Op*x,1);


%% Solve the problem

alpha_in = zeros(N,1);

paramsolver.tol = 1e-8;
paramsolver.maxit = maxit;
paramsolver.verbose = verbose;
%alpha = generalized_forward_backward(alpha_in, {ffid,ftik},fp,paramsolver);
% argmin_alpha || K alpha - y ||_2^2 + alpha^t K alpha 
alpha = solvep(alpha_in, {ffid,fp} ,paramsolver);
% argmin_alpha || K alpha - y ||_2^2 + alpha^t K^T L K alpha 
alpha2 = solvep(alpha_in, {ffid,fp,ftik} ,paramsolver);
% argmin_alpha || K alpha - y ||_2^2 +  || nabla_G K alpha ||_1 
alpha3 = solvep(alpha_in, {ffid,fp, ftv} ,paramsolver);

% argmin_alpha || K alpha - y ||_2^2 + || Khalf alpha ||_1
alpha7 = solvep(alpha_in, {ffid,fp1} ,paramsolver);

% argmin_alpha || K alpha - y ||_2^2 + || Khalf alpha ||_1 +  || nabla_G K alpha ||_1 
alpha8 = solvep(alpha_in, {ffid,fp1,ftv} ,paramsolver);

%% Display the results
x = linspace(0,1,1000);
y = frkhs( x,alpha,xi,k );
y2 = frkhs( x,alpha2,xi,k );
y3 = frkhs( x,alpha3,xi,k );

y7 = frkhs( x,alpha7,xi,k );
y8 = frkhs( x,alpha8,xi,k );


   %%
figure(1);
plot(       xi(:,1:M),yi,'ob',...
            xi,zeros(size(xi)),'xk',...
            x,freal(x),'-b',...
            x,y,'-g',...
            x,y2,'-c',...
            x,y3,'-r'...
         ... %  x,y7,'-b',...
         ... %  x,y8,'--m'...
            );
h = legend('Labeled samples',...
       'Unlabeled samples',...       
       'Function: f',...
       'Regularization: $\gamma_\mathcal{K} \|f\|_\mathcal{K} $',...
       'Regularization: $\gamma_\mathcal{K} \|f\|_\mathcal{K} + \gamma_\mathcal{M} \|\nabla_\mathcal{G}{\bf f}\|_2^2$',...
       'Regularization: $\gamma_\mathcal{K} \|f\|_\mathcal{K} + \gamma_\mathcal{M} \|\nabla_\mathcal{G}{\bf f}\|_1$',...
      ...% 'Regression: L1 RKHS',...
      ...% 'Regression: L1 RKHS + TV graph',...
       'Location',[0.5433 0.1746 0.4465 0.2682]);
   
   thesis_resize(gcf,0.6);
   thesis_printfig(gcf,'example_tv_tik_1d')
