close all

x = [0:0.03:10]';
y = 0.1*sin(30*x)+2*mod(round(x),2)-1;
paramtv.use_fast = 1;

ytv = prox_tv1d(y,1,paramtv);
ytik = prox_l2grad(y,5);

figure(1)
plot(x,y,'g',x,ytik,'r',x,ytv,'b');
axis([0,10, -1.3 2]);
xlabel('i');
ylabel('\bf{f}[i]')
title('Signal')
legend('Original: $\bf{y}$ ','Tikhonov regularized: $\dot{\bf{f}}_1$','TV regularized: $\dot{\bf{f}}_2$')
thesis_resize(gcf,0.5);
thesis_printfig(gcf,'diff_tv_tik_functions')

figure(2)
plot(x,gradient_op1d(y),'g',x,gradient_op1d(ytv),'b',x,gradient_op1d(ytik),'r');
xlabel('$i$')
ylabel('$(\nabla \bf{f})[i]$')
axis([0,10, -2.5 4]);
title('Gradients')
legend('Original: $\bf{y}$ ','TV regularized: $\dot{\bf{f}}_2$','Tikhonov regularized: $\dot{\bf{f}}_1$')
thesis_resize(gcf,0.5);
thesis_printfig(gcf,'diff_tv_tik_gradients')
