%% Demo PSD

gsp_reset_seed(2)
close all


N = 5000;

G = gsp_ring(N);
G = gsp_update_weights(G,G.W/8);
G.lmax = 0.5;

g = @(x) exp(-6*x/G.lmax).*cos(20*x/G.lmax);
%%
figure(1)
e = (2-2*cos(2*pi*(0:G.N/2)'/G.N))/8;
plot(linspace(0,0.5,length(e)) ,g(e).^2,'LineWidth',3)
axis tight
xlabel('Normalized frequencies')
title('PSD')
thesis_resize(gcf,0.3);
thesis_printfig(gcf,'demo_psd_slide_ori')
%%
x = randn(N,1);
s = real(gsp_filter(G,g,x));
M = 100;
a = 10;

win = gabwin('gauss',a,M,N);

c = dgtreal(win,s,a,M);

figure(2)
plot(s)
xlabel('Time')
title('Signal')
axis tight
thesis_resize(gcf,0.3);
thesis_printfig(gcf,'demo_psd_slide_sig')
%%
figure(3)
imagesc(linspace(0,0.5,M),linspace(0,N,a/1+1),abs(c').^2)
ylabel('Time')
xlabel('Normalized frequencies')
title('Squared modulus of the STFT')
thesis_resize(gcf,0.3);
thesis_printfig(gcf,'demo_psd_slide_coef')
%%
p = sum(abs(c).^2,2)/ norm(win)^2/size(c,2);
figure(4)
plot(linspace(0,0.5,length(p)),p,'Linewidth',3)
axis tight
xlabel('Normalized frequencies')
title('PSD estimation')
thesis_resize(gcf,0.3);
thesis_printfig(gcf,'demo_psd_slide_est')
