% plot_some_images_ws(X, pix_y, pix_x, n_rows, n_cols)
% Plot some images with white stripes
%
% example: 
% 
% load att_faces
% figure; plot_some_images(att_faces, 112, 92, 10, 10)
%
% load coil_20
% figure; plot_some_images(X, 128, 128, 15, 15)
%
% load coil_5_unprocessed
% figure; plot_some_images(X, 416, 448, 5, 5)
%
%
% code author: Vassilis Kalofolias, modified by Nathanal Perraudin
% date: 2015

function plot_some_images_ws(X, pix_y, pix_x, n_rows, n_cols)

% the big image
offy = round(pix_y*0.05);
offx = round(pix_x*0.05);
I = ones(pix_y * n_rows+(n_rows-1)*offy, pix_x * n_cols+(n_cols-1)*offx);

% index of image
k = 0;
oy = 0;
for i = 1:n_rows
    ox = 0;
    for j = 1:n_cols
        k = k + 1;
        I(oy+(1+(i-1)*pix_y : i*pix_y),ox +( 1+(j-1)*pix_x : j*pix_x)) = reshape(X(:, k), pix_y, pix_x);
        ox = ox + offx;
    end
    oy = oy + offy;
end
%imshow(I, []);
imagesc(I);
colormap gray

