% test for the reviewer

set(0,'DefaultTextInterpreter','Latex')


N = 20;

G = gsp_ring(N);
G = gsp_create_laplacian(G,'normalized');
G = gsp_compute_fourier_basis(G);

g = @(x) exp(-x);

gL = G.U*diag(g(G.e))*G.U';
sum(abs(imag(gL(:))))
figure(1) 
imagesc(real(gL))

figure(2)

imagesc(abs(G.U'*gL*G.U))

fig3 = figure(3);
G = thesis_graph_plotting(G);
gsp_plot_graph(G)
title('$20$-node ring')

thesis_resize(fig3,[0.3 0.2]);
thesis_printfig(fig3,'ring20')


%%
N = 20;

G = gsp_ring(N);
%G = gsp_create_laplacian(G,'normalized');
G = gsp_compute_fourier_basis(G);

l=(0:N-1);

fig4 = figure(4);
plot(l,G.e,'x-')
ylabel('Laplacian eigenvalue: $\lambda$');
xlabel('Index: $\ell$ ');
title('Ascending order');
axis([0 (N-1) 0 4]);
thesis_resize(fig4,[0.3 0.2]);
thesis_printfig(fig4,'ascent_order')


fig5 = figure(5);
lambda = 2 - 2*cos(2*pi*l/N);
plot(l,lambda,'x-')
ylabel('Laplacian eigenvalue: $\lambda$');
xlabel('Index: $k$ ');
title('Classical order');
axis([0 (N-1) 0 4]);
thesis_resize(fig5,[0.3 0.2]);
thesis_printfig(fig5,'classical_order')


