gsp_reset_seed();
%close all
clear;

N = 200;

G = gsp_sensor(N);
%G = gsp_update_weights(G,G.W>0);
%clG = gsp_create_laplacian(G,'normalized');
G = gsp_compute_fourier_basis(G);


[d,ind] = sort(G.d,'descend');

figure(3)
surf(N:-1:1,G.e,abs(G.U(ind,:)'),'linestyle','none')
view([0 90])
ylim([0 G.lmax])
xlim([1,G.N])
xlabel('Node sorted by degree')
ylabel('Graph spectrum')
title('Modulus of the Fourier basis')
hold on
plot(N:-1:1,d,'y','LineWidth',4)
set(gca,'Position',[0.1603 0.1855 0.7 0.7])
hNewAxes = axes('Position',[0.1603 0.1855 0.7 0.7],...  %# Place a new axes on top...
                'Color','none',...           %#   ... with no background color
                'YLim',[0 G.lmax],...            %#   ... and a different scale
                'YAxisLocation','right',...  %#   ... located on the right
                'XTick',[],...               %#   ... with no x tick marks
                'Box','off',...                %#   ... and no surrounding box
                'Units', 'normalized',...
                'GridLineStyle', '-');
ylabel(hNewAxes,'Node degree'); 
thesis_resize(gcf,0.3)
thesis_printfig(gcf,'sensor_degree_fourier');
figure(2)
gsp_plot_signal(G,G.d);
title('Node degree')
thesis_resize(gcf,0.3)
thesis_printfig(gcf,'sensor_degree_vertex');

% figure(3)
% plot(1:N,G.e,N:-1:1,d)