function G = gsp_special_community(cs1,cs2,param)

if nargin<3
    param = struct;
end

G1 = gsp_community2(cs1,param);
G2 = gsp_community2(cs2,param);
N1 = G1.N;
N2 = G2.N;

W = [G1.W, sparse(N1,N2); ...
    sparse(N1,N2), G2.W];

coords2 = G2.coords;
coords2(:,1) = coords2(:,1) + max(G1.coords(:,1))*1.15-1.15*min(coords2(:,1));
coords = [G1.coords; ...
    coords2];
G = gsp_graph(W,coords);


end