function [ SG,mu ] = gsp_graph_sgram( G,g,param )
%GSP_GRAPH_SGRAM

if nargin<3
    param = struct;
end

if ~isfield(param,'rand_sig_number'), param.rand_sig_number = 100; end
if ~isfield(param,'exact'), param.exact = 0; end
if ~isfield(param,'paramfilter'), param.paramfilter = struct; end


if numel(g)==1
    if ~isfield(param,'mu')
        if ~isfield(param,'M'), param.M = 100; end
        param.mu = linspace(0,G.lmax,param.M);
    end
    mu = param.mu;

    h = cell(numel(mu),1);
    for ii = 1:numel(mu)
        h{ii} = @(x) g(x-mu(ii));
    end
else
    h = g;
    mu = gsp_filter_mass_center(G,g);
end


SG = gsp_norm_tig(G,h,param.exact,param.rand_sig_number,param.paramfilter);


end

