function G = gsp_graph_mix()


%comet
N1=20;
k1=10;
G1=gsp_comet(N1,k1);

%full connected
N2=10;
G2=gsp_full_connected(N2);

%sensor
N3=100;
% G3=gsp_sensor(N3);
load G3;

%% big graph
% big connectivity matrix with some noise
size1=size(G1.W); size2=size(G2.W); size3=size(G3.W);
noise12=noiseMatrix( size2(1),size1(2),0.05/N1 );
noise13=noiseMatrix( size3(1),size1(2),0.05/N2 );
noise23=noiseMatrix( size3(1),size2(2),0.05/N3 );


W=blkdiag(G1.W,G2.W,G3.W);
W(N1+1:N1+N2,1:N1)=noise12;
W(N1+N2+1:N1+N2+N3,1:N1)=noise13;
W(N1+N2+1:N1+N2+N3,N1+1:N1+N2)=noise23;

W(1:N1,N1+1:N1+N2)=noise12';
W(1:N1,N1+N2+1:N1+N2+N3)=noise13';
W(N1+1:N1+N2,N1+N2+1:N1+N2+N3)=noise23';

%creating big graph
G.W=W>0;

G.coords(1:N1,1)=G1.coords(:,1);
G.coords(1:N1,2)=G1.coords(:,2)+11;

G.coords(N1+1:N1+N2,1)=G2.coords(:,1);
G.coords(N1+1:N1+N2,2)=G2.coords(:,2)+5;

G.coords(N1+N2+1:N1+N2+N3,1)=G3.coords(:,1)*10+2;
G.coords(N1+N2+1:N1+N2+N3,2)=G3.coords(:,2)*10;

G = gsp_graph_default_parameters(G);


end


function [ noise ] = noiseMatrix( sizex,sizey,p0 )

noise=zeros(sizex,sizey);
%p0 = 4/N1;
numb1=p0*sizex*sizey;
counter=0;
for i=1:sizex
    for j=1:sizey
        if counter<=numb1
            counter=counter+1;
            noise(i,j)=1;
        else break
        end
    end
end
p=randperm(prod(size(noise)));
noise(:)=noise(p);

end

