%% Idea

clear;
close all;

Nf = 20;

param.com_density = 0.5;
G = gsp_community2([10, 30, 90, 10, 30, 90],param);
% G = gsp_compute_fourier_basis(G);
G = gsp_estimate_lmax(G);
g = gsp_design_itersine(G,Nf);
N = G.N;
M = 10*N/Nf;
w = sign(randn(N,M))./sqrt(N);

x = gsp_vec2mat(gsp_filter(G,g,w),Nf);

U = zeros(N);
e = zeros(N,1);
ind = 1;
for ii = 1:Nf
    
    [Ui,Si,Vi] = svdecon(reshape(x(:,ii,:),N,M));
    for jj = 1:M
        %if Si(jj,jj)>0.1;
            vi = G.L * Ui(:,jj);
            % A) Compute eigenvalue
            ei = norm(vi);
            % B) Check if it is good
            if abs( vi' *  Ui(:,jj))>0.8*ei
                % C) Check orthogonality
                if max(abs((U'*Ui(:,jj))))<0.1
                    U(:,ind) = Ui(:,jj);
                    e(ind) = ei;
                    ind = ind+1;
                end
            end
        %end
        
    end
end

G = gsp_compute_fourier_basis(G);
figure(1)
subplot(121)
imagesc(abs(G.U))
subplot(122)
imagesc(abs(U))

figure(2)
imagesc(U'*G.U)