%% Illustration of the localization operator

clear
close all

gsp_reset_seed(0);
N = 100;
G = gsp_sensor(N);
G = gsp_compute_fourier_basis(G);

nodes = [1,34,83];

g = @(x) (10*x)/G.lmax.*exp(-(10*x).^2/G.lmax^2);



figure(1)
subplot(221)
gsp_plot_filter(G,g);
title('$g(x) = \frac{5x}{\lambda_{\max }}\exp\left(-\frac{25 x^2}{\lambda_{\max }^2}\right)$')

lat = gsp_localize(G,g,nodes);

c = [min(lat(:)) max(lat(:))];
subplot(222)
paramplot.vertex_highlight = nodes(1);
gsp_plot_signal(G,lat(:,1),paramplot);
caxis(c);
subplot(223)
paramplot.vertex_highlight = nodes(2);
gsp_plot_signal(G,lat(:,2),paramplot);
caxis(c);

subplot(224)
paramplot.vertex_highlight = nodes(3);
gsp_plot_signal(G,lat(:,3),paramplot);
caxis(c);

thesis_resize(gcf,0.6);
thesis_printfig(gcf, 'demo_localization_wavelet')

g = @(x) exp(-10*x/G.lmax);
%%
figure(2)
subplot(221)
gsp_plot_filter(G,g);
title('$g(x) = \exp\left(-\frac{10 x}{\lambda_{\max }}\right)$')

lat = gsp_localize(G,g,nodes);

c = [min(lat(:)) max(lat(:))];
subplot(222)
paramplot.vertex_highlight = nodes(1);
gsp_plot_signal(G,lat(:,1),paramplot);
caxis(c);
subplot(223)
paramplot.vertex_highlight = nodes(2);
gsp_plot_signal(G,lat(:,2),paramplot);
caxis(c);

subplot(224)
paramplot.vertex_highlight = nodes(3);
gsp_plot_signal(G,lat(:,3),paramplot);
caxis(c);

thesis_resize(gcf,0.6);
thesis_printfig(gcf, 'demo_localization_heat')