%% Demo graph spectrogram
clear;
close all;
gsp_reset_seed()

global extvar;
if extvar
    % use external variable
    global M
    global name
    global type
    global normalized
else
    M = 30;
    name = 'tree'; % tree, erdos, community, mix, comet, disconnected
    type = 'spectrogram'; % spectrogram, scaleogram, fourier, degree
    normalized = 0;
end

switch name
    case 'tree'
        %G = gsp_low_stretch_tree(4);
        G = gsp_tree(4,3);
        Nc = 5;
        filt = 0;
    case 'sensor'
        N = 256;
        G = gsp_sensor(N);
        filt = 0;
        Nc = 4;
        
    case 'erdos'
        N = 256;
        G = gsp_erdos_renyi(N,8/N);
        filt = 0;
        Nc = 2;
    case 'community'
        param.com_density = 0.5;
        G = gsp_community2([10, 30, 60, 10, 30, 60],param);
        Nc = 3;
        filt = 0;
    case 'mix'
        G = gsp_graph_mix;
        Nc = 5;
        filt = 1;
    case 'comet'
        G = gsp_comet();
        filt = 0;
        Nc = 3;
    case 'disconnected'
        param.com_density = 0.5;
        G = gsp_special_community([30, 90],[30,90],param);
        filt = 0;
        Nc = 2;
    otherwise
        error('Unknown name')
end

if filt
    features_type = [type,'_filtered'];
else
    features_type = type;
end

% For the normalized case
if normalized
    G = gsp_create_laplacian(G,'normalized');
end

G = gsp_compute_fourier_basis(G);

% In an attempt to sort the nodes :-)
% [~,ind] = sort(G.U(:,2));
if strcmp(name,'sensor')
    [~, ind] =  sort(G.d);
else
    ind = 1:G.N;
end

%%  Compute the spectrogram

switch type
    case 'spectrogram'
        %         if 0
        %             sigma = G.lmax/M;
        %             g = @(x) exp(-x.^2/sigma);
        %             param.M  = M;
        %             figure(3)
        %             x = -12*sigma :0.01: 12*sigma;
        %             plot(x,g(x));
        %             title('Windows used')
        %         else
        paramfilter.overlap = 4;
        [g, mu] = gsp_design_itersine(G,M, paramfilter);
        %             figure(3)
        %             gsp_plot_filter(G,g)
        %             title('Windows used')
        %         end
        paramsgram.exact = 1;
        GS = gsp_graph_sgram( G,g, paramsgram);
    case 'scaleogram'
        paramsgram.exact = 1;
        mu = logspace(0.1,1.5,M);
        h =@(x) x.*exp(-x/G.lmax)/G.lmax;
        [GS,h] = gsp_graph_scaleogram(G,h,mu,paramsgram);
    case 'fourier'
        tol = G.lmax*1e-10;
        mu =uniquetol(G.e,tol);
        paramsgram.mu = mu;
        paramsgram.exact = 1;
        h = @(x) abs(x)<tol;
        [GS,g] = gsp_graph_sgram(G,h,paramsgram);
        GS = sqrt(GS);
        %         GS = abs(G.U);
        %         mu = G.e;
    case 'degree'
        GS = G.d;
        mu = 0;
        %         GS = abs(G.U);
        %         mu = G.e;
    otherwise
        error('Unknown type')
end

%% Low pass filter
glow = gsp_design_heat(G,20);
% figure(3)
% gsp_plot_filter(G,glow);
GS_filt = gsp_filter_analysis(G,glow,GS);

%%
if (strcmp(type,'fourier') || strcmp(type,'spectrogram') || strcmp(type,'scaleogram'))
    figure(1)
    if filt
        surf(1:G.N,mu,real(GS_filt(ind,:)'),'linestyle','none');
    else
        surf(1:G.N,mu,real(GS(ind,:)'),'linestyle','none');
    end
    view([0 90])
    ylim([min(mu) max(mu)])
    xlim([1,G.N])
    xlabel('Node index')
    switch type
        case 'spectrogram'
            ylabel('Graph spectrum')
            title('Graph spectrogram');
        case 'scaleogram'
            ylabel('Scale')
            title('Graph scaleogram');
        case 'fourier'
            ylabel('Graph spectrum')
            title('Amplitude of the Fourier basis');
    end
    colorbar
    thesis_resize(gcf,0.3);
    thesis_printfig(gcf,['dcf_features_',features_type,'_',name]);
end
%%
if strcmp( type, 'spectrogram')
    figure(2)
    
    subplot(121)
    Nx = 1000;
    %x = linspace(0,G.lmax,Nx);
    
    %n1 = sum(gsp_filter_evaluate(g,x).^2)*G.lmax/Nx;
    
    %plot(mu,sum((GS.^2),1)/(n1*sum(GS.^2,1)'),'x-')
    plot(mu,sum((GS.^2),1)/G.N,'x-')
    xlim([0,G.lmax]);
    title('Eigenvalues density estimation');
    
    subplot(122)
    hist(G.e,20)
    xlim([0,G.lmax]);
    
    title('Eigenvalues histogram');
    
    thesis_resize(gcf,[0.6,0.2]);
    thesis_printfig(gcf,['dcf_histogram_estimation_',name])
end




%%

transform_features = @(x) cumsum(x)./repmat(sum(x),size(x,1),1);

if ~strcmp(name,'erdos')
    
    figure(4);
    if filt
        features = real(GS_filt);
    else
        features = real(GS);
    end
    
    %     features = abs(G.U);
    if   strcmp(type,'spectrogram')
        features = transform_features(features')';
    end
    %    dist = get_emd_distance(M);
    %   idx = clusterdata(features,'maxclust',3); % 'distance',dist
    idx = kmeans(features,Nc,'Distance','cityblock','Replicates', 10);
    gsp_plot_signal(G,idx);
    switch type
        case 'degree'
            title(['Degree clustering: ' name])
        case 'spectrogram'
            title(['Structural clustering: ' name])
        case 'scaleogram'
            title(['Scaleogram clustering: ' name])
    end
    
    thesis_resize(gcf,0.3);
    thesis_printfig(gcf,['dcf_structural_clustering_',features_type,'_',name]);
end

%%
if strcmp(name,'sensor') && strcmp(type,'spectrogram')
    
    map = brewermap(Nc,'Set1');
    %map = map([2 4 3 5 1],:);
    figure(5)
    hold on
    class = cell(Nc,1);
    for ii = 1:Nc
        histogram(G.d(idx==ii),linspace(0,max(G.d),30),'facecolor',map(ii,:),'facealpha',.5,'edgecolor','none');
        class{ii} = ['Class ', num2str(ii)];
    end
    
    box off
    axis tight
    title('Nodes degree histogram');
    h = legend(class,'Position',[0.6726 0.4350 0.2857 0.4500]);
    thesis_resize(gcf,0.3)
    thesis_printfig(gcf,['dcf_hist_degree_',name])
    
    
end


%%
%if strcmp(name,'community')
figure
G2 = gsp_create_laplacian(G,'normalized');
idx2 = kmeans(G2.U(:,1:Nc),Nc,'Replicates', 10);
gsp_plot_signal(G2,idx2);
title(['Spectral clustering: ', name])
thesis_resize(gcf,0.3);
thesis_printfig(gcf,['dcf_spectral_clustering_',name])
%end
%%

figure()

surf(1:G.N,G.e,abs(G.U(ind,:))','linestyle','none');
view([0 90])
xlim([1,G.N])
ylim([0 G.lmax])
xlabel('Node index');
ylabel('Graph spectrcum');
title('Fourier modulus');

hold on;
plot(0:(G.N-1),G.d(ind),'r.','Linewidth',3)
set(gca,'Position',[0.1603 0.1855 0.7 0.7])
hNewAxes = axes('Position',[0.1603 0.1855 0.7 0.7],...  %# Place a new axes on top...
    'Color','none',...           %#   ... with no background color
    'YLim',[0 G.lmax],...            %#   ... and a different scale
    'YAxisLocation','right',...  %#   ... located on the right
    'XTick',[],...               %#   ... with no x tick marks
    'Box','off',...                %#   ... and no surrounding box
    'Units', 'normalized',...
    'GridLineStyle', '-');
ylabel(hNewAxes,'Vertex degree');
thesis_resize(gcf,0.3);
thesis_printfig(gcf,['dcf_fourier_modulus_',name])

%%
if strcmp(type,'spectrogram')
x = linspace(0,G.lmax,1000);
dist_fourier_emd = squareform(pdist(gsp_fourier_cdf(G,x)/numel(x),'cityblock'));


figure()
subplot(221)
%imagesc(squareform(pdist(abs(G.U(ind,:)).^2,'cityblock')));
imagesc(dist_fourier_emd(ind,ind));
colorbar;
title('Structural distance');
subplot(222)
%imagesc(gsp_distanz( sqrt(GS(ind,:))'));
imagesc(squareform(pdist(transform_features(GS(ind,:)')'/numel(mu),'cityblock' )));
colorbar;
title('Estimated structural distance');

subplot(223)
%imagesc(gsp_distanz(G.d(ind)'));
imagesc(squareform(pdist(G.d(ind),'cityblock')));
colorbar;
title('Degree distance');

subplot(224)
imagesc(squareform(pdist( GS(ind,:),'cityblock')));
%imagesc(squareform(pdist(transform_features(GS_filt(ind,:)')','cityblock' )));
colorbar;
title('Spectrogram distance');

thesis_resize(gcf,0.5);
thesis_printfig(gcf,['dcf_distances_',name])

end
%%
if strcmp(type,'spectrogram')
    transform_features = @(x) cumsum(x)./repmat(sum(x),size(x,1),1);
    sp_feat = transform_features(GS');
    figure();
    
    surf(1:G.N,mu,sp_feat(:,ind),'linestyle','none');
    view([0 90])
    ylim([min(mu) max(mu)])
    xlim([1,G.N])
    xlabel('Node index');
    ylabel('Graph spectrum')
    title('Estimated CDF');
    hold on;
    plot3(1:G.N,G.d(ind),max(sp_feat(:))*1.1*ones(G.N,1),'.r','Linewidth',3)
    set(gca,'Position',[0.1603 0.1855 0.7 0.7])
    hNewAxes = axes('Position',[0.1603 0.1855 0.7 0.7],...  %# Place a new axes on top...
        'Color','none',...           %#   ... with no background color
        'YLim',[0 max(G.d)],...            %#   ... and a different scale
        'YAxisLocation','right',...  %#   ... located on the right
        'XTick',[],...               %#   ... with no x tick marks
        'Box','off',...                %#   ... and no surrounding box
        'Units', 'normalized',...
        'GridLineStyle', '-');
    ylabel(hNewAxes,'Node degree');
    thesis_resize(gcf,0.3);
    thesis_printfig(gcf,['dcf_estimated_CDF_',name])
end
%%
x = linspace(0,G.lmax,1000);
sp_feat = gsp_fourier_cdf(G,x)';

figure()
surf(1:G.N,x',sp_feat(:,ind),'linestyle','none');
view([0 90])
ylim([0 G.lmax])
xlim([1,G.N])
xlabel('Node index');
ylabel('Graph spectrum')
title('CDF of the Laplacian eigenvectors');
hold on;
plot3(1:G.N,G.d(ind),max(sp_feat(:))*1.1*ones(G.N,1),'r.','Linewidth',3)
set(gca,'Position',[0.1603 0.1855 0.7 0.7])
hNewAxes = axes('Position',[0.1603 0.1855 0.7 0.7],...  %# Place a new axes on top...
    'Color','none',...           %#   ... with no background color
    'YLim',[0 max(G.d)],...            %#   ... and a different scale
    'YAxisLocation','right',...  %#   ... located on the right
    'XTick',[],...               %#   ... with no x tick marks
    'Box','off',...                %#   ... and no surrounding box
    'Units', 'normalized',...
    'GridLineStyle', '-');
ylabel(hNewAxes,'Node degree');
thesis_resize(gcf,0.3);
thesis_printfig(gcf,['dcf_CDF_eigenvectors_',name])



