


clear
close all;
%% Image
%img = peppers();
load('img.mat');
M = 20;
%% Build the graph
param.nnparam.use_flann = 1;
param.patch_size = 11;
G = gsp_patch_graph(img,param);
G = gsp_estimate_lmax(G);

%% Chose filterbank


g = gsp_design_itersine(G,M);

%% Compute spectral features

% A)
%ntig = gsp_norm_tig(G,g,0,20).^2;

% B)
param.rand_sig_number = 20;
[ ntig,mu ] = gsp_graph_sgram( G,g,param);

% C)
% mu = logspace(0.1,1.5,M);
% h =@(x) x.*exp(-x/G.lmax)/G.lmax;
% [ntig,g] = gsp_graph_scalogram(G,h,mu,param);
%% Filter spectral features

glow = gsp_design_heat(G,200);
ntig_filt = gsp_filter_analysis(G,glow,ntig);




%% Cluster spectral features
Nc = 4;
%cluster = kmeans(ntig_filt,Nc,'Replicates', 10);
transform_features = @(x) cumsum(x)./repmat(sum(x),size(x,1),1);

cluster = kmeans(transform_features(ntig')',Nc,'replicates',10,'Distance','cityblock');
%cluster = kmeans(gsp_filter_analysis(G,glow,G.d),Nc,'replicates',10,'Distance','cityblock');

% Ordering of the color

a = zeros(Nc,1);
for ii = 1 : Nc
%    a(ii) = sum(ntig_filt(cluster==ii,1)); 
    a(ii) = sum(G.d(cluster==ii)); 
end

[as,ind] = sort(a);

sorted_cluster = zeros(G.N,1);
for ii = 1 : G.N
    sorted_cluster(ii) = ind(cluster(ii)); 
end

%% Display the results

figure(1)

imagesc(img)
caxis([0,1])
colormap gray
title('Original image')
axis off
thesis_resize(gcf,[0.4,0.4]);
thesis_printfig(gcf,'demo_clustering_original');

%%
figure(2)

imagesc(reshape(sorted_cluster,512,512))
axis off
title('Clusters')
thesis_resize(gcf,[0.4,0.4]);
thesis_printfig(gcf,'demo_clustering_clusters');
%%

figure(3)
plot_some_images(ntig, 512, 512, 2, 2)
caxis([0 max(ntig_filt(:))]);
colormap(jet)
axis off
title('Spectral features')
thesis_resize(gcf,[0.4,0.4]);
thesis_printfig(gcf,'demo_clustering_features');


figure(4)
plot_some_images(ntig_filt, 512, 512, 2, 2)
caxis([0 max(ntig_filt(:))]);
colormap(jet)
axis off
title('Spectral features after smoothing')
thesis_resize(gcf,[0.4,0.4]);
thesis_printfig(gcf,'demo_clustering_features_smooth');


figure(5)
gsp_plot_filter(G,g);
title('Filterbank')

thesis_resize(gcf,[0.5,0.2]);
thesis_printfig(gcf,'demo_clustering_filterbank');

figure(6)
gsp_plot_filter(G,glow);
title('Low pass kernel');
thesis_resize(gcf,[0.3,0.2]);
thesis_printfig(gcf,'demo_clustering_lowpass');