%% Illustration of the localization operator

clear
close all

gsp_reset_seed(0);

G = gsp_comet(8,3);

G = gsp_compute_fourier_basis(G);

nodes = [1,2,3];

g = @(x) sin(x).*exp(-x);



figure(1)
subplot(221)
gsp_plot_filter(G,g);
title('Filter: $g(x) = e^{-x} \cdot sin(x)$')

lat = gsp_localize(G,g,nodes);

c = [min(lat(:)) max(lat(:))];
subplot(222)
paramplot.vertex_highlight = nodes(1);
gsp_plot_signal(G,lat(:,1),paramplot);
caxis(c);
title('$\mathcal{T}_1^{\mathcal{G}}g$')
subplot(223)
paramplot.vertex_highlight = nodes(2);
gsp_plot_signal(G,lat(:,2),paramplot);
caxis(c);
title('$\mathcal{T}_2^{\mathcal{G}}g$')

subplot(224)
paramplot.vertex_highlight = nodes(3);
gsp_plot_signal(G,lat(:,3),paramplot);
caxis(c);
title('$\mathcal{T}_3^{\mathcal{G}}g$')

thesis_resize(gcf,0.6);
thesis_printfig(gcf, 'demo_isomorphism')