
gsp_reset_seed(4)

N = 100;
Nf = 10;
Nc = 5;

param.distribute = 1;
G = gsp_sensor(N,param);

G = gsp_compute_fourier_basis(G);

g = gsp_design_itersine(G,Nf);

C = zeros(N,Nf);
for i = 1:Nc
    C(randi(N,1),randi(Nf,1)) = 1;
end

x = gsp_filter_synthesis(G,g,gsp_mat2vec(C));
Cp = gsp_vec2mat(gsp_filter_analysis(G,g,x),Nf);

figure(1)
gsp_plot_signal(G,x);
title('Signal: ${\bf x} = \sum_k g_k({\bf L}){\bf c}_k$')
thesis_resize(gcf,0.3);
thesis_printfig(gcf,'uncertainty_illustration_sig');

figure(2)
subplot(121)
imagesc(C)
title('Original Coefficients: ${\bf c}_k$')

subplot(122)
imagesc(abs(Cp))
title('Analysis: $\tilde{{\bf c}}_k = g_k({\bf L}){\bf x}$')

thesis_resize(gcf,0.6);

thesis_printfig(gcf,'uncertainty_illustration_coef');

figure(3)
gsp_plot_filter(G,g)
title('Filterbank: $\{g_k\}_{k=1,\dots, K}$')
thesis_resize(gcf,0.3);

thesis_printfig(gcf,'uncertainty_illustration_filters');