%DISPLAY_RING_PATH Display the ring and the path graph nicely
%
%   This script display a ring graph and a path graph nicely and format
%   them for the paper : ....
%
%   This script uses the GSPBOX

% Author: Nathanael Perraudin
% Date  : 29.11.2013

%% Initialization
close all
clear

gsp_reset_seed(0);
%% Plotparameter

paramplot.show_edges = 1;
set(0,'DefaultTextInterpreter','Latex')


%% Create a sensor graph
N = 64;
paramsensor.distribute = 1;
G = gsp_sensor(N,paramsensor);
G.plotting.edge_color = [0.6 0.6 0.6];
G = gsp_compute_fourier_basis(G);
G = thesis_graph_plotting(G);

%% Create a signal
sigma = 0.05;
s = G.U(:,3) + sigma *randn(N,1);


%% Display the graph
% figure(1)
% gsp_plot_signal(G,s);
% gsp_plotfig('sensor_graph_signal',paramplot)

fig1 = figure(1);
gsp_plot_signal(G,G.d);
thesis_resize(fig1,[0.3 0.2]);
thesis_printfig(fig1,'sensor_graph_signal');

%% Display some eigenfunctions

fig2 = figure(2);
subplot(221);
gsp_plot_signal(G,G.U(:,1));
title('First eigenvector');
caxis([-0.25,0.25]);

subplot(222);
gsp_plot_signal(G,G.U(:,2));
title('Second eigenvector');
caxis([-0.25,0.25]);

subplot(223);
gsp_plot_signal(G,G.U(:,4));
title('Fourth eigenvector');
caxis([-0.25,0.25]);

subplot(224);
gsp_plot_signal(G,G.U(:,10));
title('Tenth eigenvector');
caxis([-0.25,0.25]);

thesis_resize(fig2,[0.6 0.4]);
thesis_printfig(fig2,'sensor_graph_eigenvectors');


%% Define a filter

g = gsp_design_expwin(G);
 
s_filt = gsp_filter(G,g,s);




fig3 = figure(3);
subplot(131)
gsp_plot_filter(G,g)
title('Filter')

subplot(132)
gsp_plot_signal(G,s);
caxis([-0.25,0.25]);
title('Noisy signal')

subplot(133)
gsp_plot_signal(G,s_filt);
caxis([-0.25,0.25]);
title('Filtered signal')

thesis_resize(fig3,[0.9 0.2]);
thesis_printfig(fig3,'ex_filter')

% %% Display some atom of the heat kernel
% 
% g = gsp_design_heat(G,7);
% N1 = 29;
% N2 = 8;
% x = zeros(N,2);
% x(N1,1) = 1;
% x(N2,2) = 1;
% s = gsp_filter_synthesis(G,g,x);
% 
% figure(9)
% gsp_plot_filter(G,g)
% title('Heat kernel')
% gsp_plotfig('sensor_graph_heat_kernel',paramplot)
% 
% figure(10)
% paramp1.vertex_highlight = N1;
% gsp_plot_signal(G,s(:,1),paramp1);
% gsp_plotfig('sensor_graph_heat_kernel_loc_1',paramplot)
% 
% figure(11)
% paramp2.vertex_highlight = N2;
% gsp_plot_signal(G,s(:,2),paramp2);
% gsp_plotfig('sensor_graph_heat_kernel_loc_2',paramplot)
% 

