%EXAMPLE_SWISS_ROLL Display a swiss roll and the corresponding surface
%
%   This script uses the GSPBOX

% Author: Nathanael Perraudin
% Date  : 24.08.2015

%% Initialization
close all
clear

%% Plotparameter
set(0,'DefaultTextInterpreter','Latex')

paramplot.show_edges = 1;




%% Manifold

% function over the manifold
%f = @(x,y,z) (x^.2+(y-0.5).^2+(z).^2) ;
f = @(x,y) sin(3*(5*x.^2+y.^2));

a = 1;   % swiss roll goes from a*pi to b*pi
b = 4;
Ns = 300;
[X1,Y1] = meshgrid(linspace(0,1,Ns),linspace(0,1,Ns));
y = [X1(:),Y1(:)]';
% uniform distribution along the manifold (in data space)
tt = sqrt((b*b-a*a)*y(1,:)+a*a);
tt = pi*tt;
% now tt should go from a*pi to b*pi
height = y(2,:);
X = reshape(tt.*cos(tt)/b^2,Ns,Ns); 
Y = reshape(height,Ns,Ns); 
Z = reshape(tt.*sin(tt)/b^2,Ns,Ns);
C = f(X1,Y1);
fig1 = figure(1);
surf(X,Y,Z,C,'EdgeColor','none','LineStyle','none','FaceLighting','phong')
colormap(jet)
view(-3, 12);
axis off
colorbar
thesis_resize(fig1,[0.3 0.2])
thesis_printfig(fig1,'swissroll_manifold')


%% Swiss-Roll
N = 500;
G = gsp_swiss_roll(N);
figure(1)
gsp_plot_signal(G,f(G.map_coord(:,1),G.map_coord(:,2)));
view(-3, 12);
thesis_resize(fig1,[0.3 0.2])
thesis_printfig(fig1,'swissroll_graph')