%EXAMPLE_SWISS_ROLL Display a swiss roll and the corresponding surface
%
%   This script uses the GSPBOX

% Author: Nathanael Perraudin
% Date  : 24.08.2015

%% Initialization
close all
clear

%% Plotparameter

set(0,'DefaultTextInterpreter','Latex')

paramplot.show_edges = 1;

%%

Nplot = 6;
N = 20;
G = gsp_path(N);
G = gsp_compute_fourier_basis(G);
G = thesis_graph_plotting(G);

fig1 = figure(1);
for ii = 1:Nplot
    subplot(ceil(Nplot/2),2,ii)
    paramplot.bar = 1;
    gsp_plot_signal(G,G.U(:,ii),paramplot)
    hold on
    scatter3(G.coords(:,1),G.coords(:,2),zeros(G.N,1),...
                    G.plotting.vertex_size*5,'.');
    view(0,0)
    colorbar off
    title(['Eigenvector ',int2str(ii-1)])
end

thesis_resize(fig1,[0.6 0.4])
thesis_printfig(fig1,'path_fourier')