%DISPLAY_RING_PATH Display the ring and the path graph nicely
%
%   This script display a ring graph and a path graph nicely and format
%   them for the paper : ....
%
%   This script uses the GSPBOX

% Author: Nathanael Perraudin
% Date  : 29.11.2013

%% Initialization
close all
clear

%% Plotparameter

paramplot.show_edges = 1;
set(0,'DefaultTextInterpreter','Latex')

%% Path graph
N = 8;
G1=gsp_path(N);
G1 = thesis_graph_plotting(G1);

N = 16;
G2 = gsp_ring(N);
G2 = thesis_graph_plotting(G2);

N = 8;
G3 = gsp_2dgrid(N);
G3 = thesis_graph_plotting(G3);

N = 10;
G4 = gsp_torus(N);
G4 = thesis_graph_plotting(G4);


fig1 = figure(1);
subplot(221); gsp_plot_graph(G1,paramplot); title('Path $8$')
subplot(222); gsp_plot_graph(G2,paramplot); title('Ring $16$');
subplot(223); gsp_plot_graph(G3,paramplot); title('Grid $8 \times 8$');
subplot(224); gsp_plot_graph(G4,paramplot); title('Torus $10 \times 10$');

thesis_resize(fig1,0.6)
thesis_printfig(fig1,'classical_graph')

%% Ring graph eigenvalues

% N = 16;
% 
% % look at the eigenvalues
% G=gsp_ring(N);
% G=gsp_compute_fourier_basis(G);
% 
% l=0:N-1;
% 
% figure
% plot(l,G1.e)
% ylabel('$\lambda$');
% xlabel('$\ell$');
% title('Ascending order');
% axis([0 N-1 min(G1.e) max(G1.e)*1.05]);
% gsp_plotfig('eig_crescent',paramplot);
% 
% figure
% 
% lambda = 2 - 2 * cos(2*pi*l/N);
% plot(l,lambda)
% ylabel('$\lambda$');
% xlabel('$\ell$');
% title('Classical order');
% 
% axis([0 N-1 min(lambda) max(lambda)*1.05]);
% gsp_plotfig('eig_classical',paramplot);
% 


