function [ psd_ext ] = gsp_jtv_interpolate_psd( psd, T)

[N,T1,Nf] = size(psd);

a = T/T1;
if ~(round(a) == a)
    error('T is not a valid length')
end

psd_ext = zeros(N,T,Nf);
omega1 = gsp_cfa( T1);
omega = gsp_cfa( T);
for ii=1:Nf
    for jj = 1:N
        psd_ext(jj,:,ii) = max(spline(omega1,psd(jj,:,ii),omega),0);
    end
end

end

