function sol = grm_js_estimator(C, M, s, sigma)

if nargin<4
    sigma = 0;
end



[N,T,Ns] = size(s);

if abs(numel(M) - N*T)
    error('M should be a matrix of size N x T')
end

s = reshape(s,N*T,Ns);
M = M(:);

Cnn = C(logical(M),logical(M));
%Cuu = C(~logical(M),~logical(M));
Cun = C(~logical(M),logical(M));
sol = zeros(size(s));
sol(logical(M),:) = Cnn * (( Cnn + sigma*eye(sum(double(M))) ) \ s(logical(M),:));
sol(~logical(M),:) = (Cun * (( Cnn + sigma*eye(sum(double(M))) ) \ s(logical(M),:)));

sol = reshape(sol,N,T,Ns);
end