function C = estimate_covariance_multivariate_stationary_process(X,g)

if nargin<2
    g = 1;
end

if (size(squeeze(g),1)-1) * (size(squeeze(g),2)-1)
    error('g cannot be a matrix')
end

[N,T,Ns] = size(X);

% 1) Fourier transform
Xhat = fft(X,[],2)/sqrt(T);

% 2) Compute the covariance matrix
I = zeros(N,N,T);
for ii = 1:T
    I(:,:,ii) = squeeze(Xhat(:,ii,:)) * squeeze(Xhat(:,ii,:))'/Ns;
end

% 3) Smooth it with a convoluation
CF = reshape(I,N^2,T);

g = g(:);
for ii = 1:N^2
    CF(ii,:) = cconv(CF(ii,:),transpose(g),T);
end
CF = reshape(CF,N,N,T);

C = ifft(CF,[],3);



end


% 
% %%
% 
% x = rand(1,T);
% g = w';
% 
% a1 = cconv(x,g,T);
% a2 = ifft(fft(x).*fft(g));
% 
% norm(a1-a2)