function C = covariance_matrix_estimation_stationary_process(Xs,w)

[N,T,Ns] = size(Xs);
w = w/norm(w,1);

if ~isreal(w)
    warning('w is not real')
end

if sum(w<0)
    warning('w is not positive')
end

if isreal(w)
    Cv = real(estimate_covariance_multivariate_stationary_process(Xs,w));
else
    Cv = real(estimate_covariance_multivariate_stationary_process(Xs,w));
end
C = zeros(N*T);
for ii = 1:T
    C(N*(ii-1)+(1:N),:) = circshift(reshape(Cv,N,N*T),[0 N*(ii-1)]);
end

end