function [ ccsA , ccsN ] = agsp_util_cc_split( A, largest )
%AGSP_UTIL_CC_SPLIT returns the adj. matrices of the connected components
%
%   CCSA = SPLITINTOCC(A) returns a cell array of adjacency matrices
%       with the same dimension of A, but nodes (and edges) not being
%       part of a component are set to zero.
%
%   [ CCSA , CCSN ] = SPLITINTOCC(A) additionally returns a cell 
%       array of vectors containing the names of the nodes in each
%       connected component.
%
%       Obiviously, length(CCSA) = length(CCSN) = ncc
%
%       If you have the distance matrix of the graph (calculated
%       via adj2dist), you can spare most of the work. Just pass
%       it on as second argument:  SPLITINTOCC( A , D )
%
%   Note each returned connected adjacency will be of the same dimension 
%       as the input A. Some of its lines however will be empty.
% 
%  Last change:  10/2/2005 - Florian Knorn

if nargin < 1
	error('Please input adjacency matrix !');
else
	n = size(A,1);
	if n ~= size(A,2)
		error('Please input SQUARE matrix !');
	end
	if nargin < 2
		D = [];
	end
end


% -- compute the distance matrix

nn = n^2; m = 0; count = []; deltannz = 42; warning off;

A = logical(A); Asum2 = logical(speye(n)); Am = Asum2;
while (nnz(Asum2) ~= nn) && (deltannz ~= 0) && (m <= n)
    m = m + 1; Am = logical(double(Am)*A);
    Asum1 = Asum2; Asum2 = Asum1 | Am;
    deltannz = nnz(Asum2)-nnz(Asum1); % increase of new shortest paths
end

if (deltannz == 0) || (m == n)
    notconn = true;
else
    notconn = false;
end
	
	
% -- graph not connected
% count ncc, find nlcc and output warning
if notconn
	ncc = 0; ccsA = {}; ccsN = {}; oneton = 1:n; rmved = [];
	while ~isempty(Asum2)

		ncc = ncc + 1;

		% grab all the nodes that are reachable from first node ...
		thiscc = find(Asum2(1,:)); 

		% note that the indices in "thiscc" are the node names in the 
		% reduced graph! so we need to know what their original names are:
		origind = oneton; origind(rmved) = []; % "simluate" removal
		thiscc_origind = origind(thiscc);

		% now, let's take care of the newly found cc (i.e. store it).
		% "removeme" are the nodes to be "removed" from the original
		% adjacency matrix (that is its rows & cols are to be set 0)
		% For that, again, transformation new->orig. indices needed.
		removeme_origind = oneton; removeme_origind(thiscc_origind) = [];
		
		ccsA{ncc} = A; % asign A and set non-cc-members to 0
		ccsA{ncc}(removeme_origind,:) = false;
		ccsA{ncc}(:,removeme_origind) = false;
		ccsN{ncc} = thiscc_origind; % store their names
		
		% finally get them out of the way (safes work in next step)
		Asum2(thiscc,:) = []; Asum2(:,thiscc) = [];
		rmved = [rmved,thiscc_origind];
    end
	
    if exist('largest','var') && largest == 1,
        idx = 0; imax = 0;
        for i = 1:length(ccsN),
            if length(ccsN{i}) > imax,
                idx = i;
                imax = length(ccsN{i});
            end
        end
%         idx
        ccsA = ccsA{idx};
        ccsN = ccsN{idx};
        
    end
    
% -- graph connected 
else 

	ccsA = {A};
	ccsN = {1:n};
    
    if exist('largest','var') && largest == 1,
        ccsA = A;
    end

end

